<?PHP

/**
 * This file is part of the Colissimo Delivery Integration plugin.
 * (c) Harasse
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

if (!defined('ABSPATH')) exit;
/****************************************************************************************/
/* Add Bordereaux Colissimo actions in the Gateway                                 */
/****************************************************************************************/
class WC_Gateway_bordereaux {
    public static function init() {
      add_action('wp_ajax_cdi_bremise_open_view',  __CLASS__ . '::cdi_ajax_bremise_open_view');
      add_action('wp_ajax_cdi_bremise_close_view',  __CLASS__ . '::cdi_ajax_bremise_close_view');
      add_action('wp_ajax_cdi_bremise_add_select',  __CLASS__ . '::cdi_ajax_bremise_add_select');
      add_action('wp_ajax_cdi_bremise_clear_select',  __CLASS__ . '::cdi_ajax_bremise_clear_select');
      add_action('wp_ajax_cdi_bremise_exec_bordereau',  __CLASS__ . '::cdi_ajax_bremise_exec_bordereau');
      add_action('admin_init',  __CLASS__ . '::cdi_bordereau_voir');
      if (class_exists ('SoapClient')) {
        require_once dirname(__FILE__) . '/ColissimoAF/ColissimoAFAutoload.php';
      }
    }

    /**
     * Manage the Bordereau Remise function.
     *
     */
    public static function bremise_manage() {
      if (WC_function_Colissimo::cdi_isconnected()) {
        eval (WC_function_Colissimo::cdi_eval('7')) ; 
        if (!get_option('cdi_br_select_fromdate') or !get_option('cdi_br_select_todate')) {
         update_option('cdi_br_select_todate', date("Y-m-d")) ;
         update_option('cdi_br_select_fromdate', date('Y-m-d', strtotime("-1 days"))) ;
        }
        if (!get_option('cdi_br_select_numorders')) {
         update_option('cdi_br_select_numorders', "") ;
        }
        if (!get_option('cdi_br_select_codesuivi')) {
         update_option('cdi_br_select_codesuivi', "") ;
        }
        if (!get_option('cdi_br_select_extern')) {
         update_option('cdi_br_select_extern', "") ;
        }
        if (!get_option('cdi_br_select_annulcode')) {
         update_option('cdi_br_select_annulcode', "") ;
        }
        ?>
        <div id="bremisemanagewrap">
          <div id="bremisemanage" style="display:none;">
            <h2>CDI Gestion des Bordereaux de Remise</h2>
            <p>
              <input type="button" id="cdi-bremise-close" class="button button-primary mode-run-bremise" value="Fermer" />
              <input type="button" id="cdi-bremise-select" class="button button-primary" value="Ajouter sélection(s)" />
              <input type="button" id="cdi-bremise-clear" class="button button-primary" value="Purger sélectés" />
              <input type="button" id="cdi-bremise-exec" class="button button-primary" value="Générer un bordereau" />
            </p>
            <div id="cdi-bremise-message-zone"></div>
            <div style="width:98%; height:calc(100vh - 50px);display:inline-block;">
              <div id="cdi-bremise-selectors" style="font-size:14px; width:30%; height:100%; display:inline-block; float:left; margin:10px; padding:10px; background-color:white;">
                <h2 style="text-align: center;">Sélecteurs</h2>
                <div ><strong>Sélection des colis à mettre en bordereau : </strong></div>
                  <div>
                    <p>
                      <input type="checkbox" id="br_select_gateway" name="br_select_gateway" unchecked style="font-size:14px; margin:10px; padding:10px;">
                      <label for="br_select_gateway"> <strong>+</strong> Colis dans la passerelle</label>
                    </p>
                    <p>                  
                      <input type="checkbox" id="br_select_orders" name="br_select_orders" unchecked style="font-size:14px; margin:10px; padding:10px;">
                      <label for="br_select_orders"> <strong>+</strong> Colis des commandes de date à date (inclues) : </label>
                    </p>
                    <p>
                      <label for="fromdate" style="margin-left:15%;">du </label>
                      <input type="text" class="custom_date" id="cdi_br_select_fromdate" name="cdi_br_select_fromdate" style="width:25%" value="<?php echo get_option('cdi_br_select_fromdate'); ?>"/>
                      <lablel for="todate">au </label>
                      <input type="text" class="custom_date" id="cdi_br_select_todate" name="cdi_br_select_todate" style="width:25%" value="<?php echo get_option('cdi_br_select_todate'); ?>"/>
                    </p>
                    <p>                  
                      <input type="checkbox" id="br_select_numorders" name="br_select_numorders" unchecked style="font-size:14px; margin:10px; padding:10px;">
                      <label for="br_select_numorders"> <strong>+</strong> Liste de N° de commandes (virgules de séparation) : </label>
                      <textarea id="br_select_numorders_param1" style="font-size:14px; margin-left:15%; width: 80%; height:50px;"><?php echo get_option('cdi_br_select_numorders'); ?></textarea>
                    </p>
                    <p>                  
                      <input type="checkbox" id="br_select_codesuivi" name="br_select_codesuivi" unchecked style="font-size:14px; margin:10px; padding:10px;">
                      <label for="br_select_codesuivi"> <strong>+</strong> liste de codes suivi (virgules de séparation) : </label>
                      <textarea id="br_select_codesuivi_param1" style="font-size:14px; margin-left:15%; width: 80%; height:50px;"><?php echo get_option('cdi_br_select_codesuivi'); ?></textarea>
                    </p>
                    <p>                  
                      <input type="checkbox" id="br_select_extern" name="br_select_extern" unchecked style="font-size:14px; margin:10px; padding:10px;">
                      <label for="br_select_extern"> <strong>+</strong> Externe - scan, appli, etc (option cdi_br_externe) : </label>
                      <textarea id="br_select_extern_param1" style="font-size:14px; margin-left:15%; width: 80%; height:50px;"><?php echo get_option('cdi_br_select_extern'); ?></textarea>
                    </p>
                    <p>                  
                      <input type="checkbox" id="br_select_annulcode" name="br_select_annulcode" unchecked style="font-size:14px; margin:10px; padding:10px;">
                      <label for="br_select_annulcode"> <strong>-</strong> Annulation de codes suivi (virgules de séparation) : </label>
                      <textarea id="br_select_annulcode_param1" style="font-size:14px; margin-left:15%; width: 80%; height:50px;"><?php echo get_option('cdi_br_select_annulcode'); ?></textarea>
                    </p>
                  </div>
              </div>
              <div id="cdi-bremise-selected" style="font-size:14px; width:20%; height:100%; display:inline-block; float:left; margin:10px; padding:10px; background-color:white;">
                <h2 style="text-align: center;">Colis sélectionnés</h2>
                <div><strong>Liste des colis sélectionnés : </strong></div>
                <div id="cdi-bremise-listeselected" style="margin:5%; height:80%; overflow: scroll;"></div>
              </div>
              <div id="cdi-bremise-cree" style="font-size:14px; width:40%; height:100%; display:inline-block; float:left; margin:10px; padding:10px; background-color:white;">
                <h2 style="text-align: center;">Bordereaux générés</h2>
                <div><strong>Historique des bordereaux générés : </strong></div>
                  <div id="cdi-brbordereaux-generes" style="margin:5%; height:80%; overflow: scroll;">
                    <form method="post">
                      <div id="outer" style="position: relative;">
                        <div id="inner" style="overflow: auto; max-height:80%;">
                          <table cellspacing="0" class="wp-list-table widefat fixed">
                            <thead>
                              <tr>
                                <th class="manage-column" id="cdi-br-date" scope="col" style="width:40%;">Date création</th>
                                <th class="manage-column" id="cdi-br-number" scope="col" style="width:20%;">Numéro</th>
                                <th class="manage-column" id="cdi-br-nbcol" scope="col" style="width:20%;">Nb Colis</th>
                                <th class="manage-column" id="cdi-br-voir" scope="col" style="width:20%;">Voir / Imprimer</th>
                              </tr>
                            </thead>
                            <tbody id="cdi-list-bordereau"></tbody>
                            <tfoot>
                              <tr>
                                <th class="manage-column" id="cdi-br-date" scope="col" style="width:40%;">Date création</th>
                                <th class="manage-column" id="cdi-br-number" scope="col" style="width:20%;">Numéro</th>
                                <th class="manage-column" id="cdi-br-nbcol" scope="col" style="width:20%;">Nb Colis</th>
                                <th class="manage-column" id="cdi-br-voir" scope="col" style="width:20%;">Voir / Imprimer</th>
                              </tr>
                            </tfoot>
                          </table>
                        </div>
                      </div>
                    </form>
                  </div>
              </div>
            </div>
            <p> </p>
          <!-- End of div id="bremisemanage" -->
          </div>
        </div> 
        <?php
        eval (WC_function_Colissimo::cdi_eval('12')) ; 
      }
    }
    public static function cdi_bremise_open_button() {
      if (WC_function_Colissimo::cdi_isconnected()) {
        eval (WC_function_Colissimo::cdi_eval('7')) ; 
        $cdi_bremise_set = get_option('cdi_bremise_set') ;
        if (!$cdi_bremise_set) {
          $color = '#0085ba' ; // Bordereau de Remise is close
        }else{
          $color = 'red' ; // Bordereau de Remise is running
        }
        update_option('cdi_bremise_set', '1') ;
        ?><em></em><input type="button" id="cdi-bremise-open" class="mode-run-bremise" value="Bordereaux de Remise" style="float: left; background-color: <?php echo $color; ?>; color:white;" title="Gestion des Bordereaux de Remise. Pour ouvrir cliquez !" /><em></em><?php
        eval (WC_function_Colissimo::cdi_eval('19')) ; 
        ?><script>
          jQuery(document).ready(function($){ 
            var cdibremiselisteselected = $( '#cdi-bremise-listeselected' );
            var cdilistbordereau = $( '#cdi-list-bordereau' );
            var cdibremisemessagezone = $( '#cdi-bremise-message-zone' );
            var ajaxurl = "<?php echo $ajaxurl; ?>";
            var doopen          = $( '#cdi-bremise-open' );
            var doclose          = $( '#cdi-bremise-close' );
            var doselect          = $( '#cdi-bremise-select' );
            var doclear          = $( '#cdi-bremise-clear' );
            var doexec          = $( '#cdi-bremise-exec' );
            function getcurrentselect() {
              var currentselect = {
                  br_select_gateway:$(document.getElementById("br_select_gateway")).is(':checked'), 
                  br_select_orders:$(document.getElementById("br_select_orders")).is(':checked'), 
                      cdi_br_select_fromdate:document.getElementById("cdi_br_select_fromdate").value,
                      cdi_br_select_todate:document.getElementById("cdi_br_select_todate").value, 
                  br_select_numorders:$(document.getElementById("br_select_numorders")).is(':checked'), 
                      br_select_numorders_param1:document.getElementById("br_select_numorders_param1").value,
                  br_select_codesuivi:$(document.getElementById("br_select_codesuivi")).is(':checked'), 
                      br_select_codesuivi_param1:document.getElementById("br_select_codesuivi_param1").value,
                  br_select_extern:$(document.getElementById("br_select_extern")).is(':checked'), 
                      br_select_extern_param1:document.getElementById("br_select_extern_param1").value,
                  br_select_annulcode:$(document.getElementById("br_select_annulcode")).is(':checked'), 
                      br_select_annulcode_param1:document.getElementById("br_select_annulcode_param1").value
                   };
              return currentselect ;
            }
            jQuery(doopen).click(function(){
              cdibremisemessagezone.html(""); 
              var doopenajax      = { 'action': 'cdi_bremise_open_view', 'select': getcurrentselect() };
              jQuery.post(ajaxurl, doopenajax, function(response) {
                arr = JSON.parse(response) ;
	        cdibremisemessagezone.html(arr['message']);
	        cdibremiselisteselected.html(arr['htmlselected']);
	        cdilistbordereau.html(arr['htmlbordereaux']);
              } );
              jQuery( "#bremisemanage" ).each(function( index ) { 
                jQuery(this).show();
	      });
              $(".mode-run-bremise").css("background-color", "red");
              jQuery('html, body').animate({ scrollTop: jQuery("#bremisemanagewrap").offset().top }, 1000);
            } );
            jQuery(doclose).click(function(){
              cdibremisemessagezone.html(""); 
              var docloseajax      = { 'action': 'cdi_bremise_close_view' };
              jQuery.post(ajaxurl, docloseajax, function(response) {
              } );
              jQuery( "#bremisemanage" ).each(function( index ) { 
                jQuery(this).hide();
	      });
              document.getElementById("br_select_numorders_param1").value = '';
              document.getElementById("br_select_codesuivi_param1").value = '';
              document.getElementById("br_select_extern_param1").value = '';
              document.getElementById("br_select_annulcode_param1").value = '';
              document.getElementById("cdi_br_select_fromdate").value = '';
              document.getElementById("cdi_br_select_todate").value = '';
              $(".mode-run-bremise").css("background-color", "#0085ba");
              jQuery('html, body').animate({ scrollTop: jQuery("#wpbody").position().top }, 1000);
            } );
            jQuery(doselect).click(function(){
              cdibremisemessagezone.html(""); 
              var doselectajax      = { 'action': 'cdi_bremise_add_select', 'select': getcurrentselect() };
              jQuery.post(ajaxurl, doselectajax, function(response) {
                arr = JSON.parse(response) ;
	        cdibremisemessagezone.html(arr['message']);
	        cdibremiselisteselected.html(arr['htmlselected']);
              } );
              document.getElementById("br_select_gateway").checked = false;
              document.getElementById("br_select_orders").checked = false;
              document.getElementById("br_select_numorders").checked = false;
              document.getElementById("br_select_codesuivi").checked = false;
              document.getElementById("br_select_extern").checked = false;
              document.getElementById("br_select_annulcode").checked = false;
            } );
            jQuery(doclear).click(function(){
              cdibremisemessagezone.html(""); 
              var doclearajax      = { 'action': 'cdi_bremise_clear_select'};
              jQuery.post(ajaxurl, doclearajax, function(response) {
                arr = JSON.parse(response) ;
	        cdibremisemessagezone.html(arr['message']);
	        cdibremiselisteselected.html(arr['htmlselected']);
              } );
              document.getElementById("br_select_gateway").checked = false;
              document.getElementById("br_select_orders").checked = false;
              document.getElementById("br_select_numorders").checked = false;
              document.getElementById("br_select_codesuivi").checked = false;
              document.getElementById("br_select_extern").checked = false;
              document.getElementById("br_select_annulcode").checked = false;
            } );
            jQuery(doexec).click(function(){
              cdibremisemessagezone.html(""); 
              var doexecajax      = { 'action': 'cdi_bremise_exec_bordereau'};
              jQuery.post(ajaxurl, doexecajax, function(response) {
                arr = JSON.parse(response) ;
	        cdibremisemessagezone.html(arr['message']);
	        cdibremiselisteselected.html(arr['htmlselected']);
	        cdilistbordereau.html(arr['htmlbordereaux']);
              } );
            } );
          });
        </script><?php
        eval (WC_function_Colissimo::cdi_eval('12')) ; 
      }
    }
    public static function cdi_get_br_selected() {
      $selected = get_option('cdi_selected_bremise') ;
      if (!$selected) {
        $selected = array() ;
        update_option('cdi_selected_bremise', $selected) ;
      }
      return $selected ;
    }
    public static function cdi_get_br_displayselected($selected) {
      $selecteddisplay = "" ;
      foreach ($selected as $sel) {
        $selecteddisplay .= $sel . '</br>' ;
      }
      return $selecteddisplay ;
    }
    public static function cdi_ajax_bremise_open_view() {
      $selected = self::cdi_get_br_selected() ;
      $selecteddisplay = self::cdi_get_br_displayselected($selected) ;
      $bordereauxdisplay = self::cdi_body_table_bordereau() ;
      echo json_encode(array("message" => "Bienvenue dans votre gestionnaire des bordereaux de remises", "htmlselected" => $selecteddisplay, "htmlbordereaux" => $bordereauxdisplay)) ;
      wp_die();
    }
    public static function cdi_ajax_bremise_close_view() {
      delete_option('cdi_br_select_todate') ;
      delete_option('cdi_br_select_fromdate') ;
      delete_option('cdi_br_select_numorders') ;
      delete_option('cdi_br_select_codesuivi') ;
      delete_option('cdi_br_select_extern') ;
      delete_option('cdi_br_select_annulcode') ;
      delete_option('cdi_bremise_set') ;
      wp_die();
    }
    public static function cdi_ajax_bremise_add_select() {
      global $wpdb;
      global $woocommerce;
      global $message;
      $select = $_POST['select'] ;
      update_option('cdi_br_select_todate', $select['cdi_br_select_todate']) ;
      update_option('cdi_br_select_fromdate', $select['cdi_br_select_fromdate']) ;
      update_option('cdi_br_select_numorders', $select['br_select_numorders_param1']) ;
      update_option('cdi_br_select_codesuivi', $select['br_select_codesuivi_param1']) ;
      update_option('cdi_br_select_extern', $select['br_select_extern_param1']) ;
      update_option('cdi_br_select_annulcode', $select['br_select_annulcode_param1']) ;
      $selected = self::cdi_get_br_selected() ;
      if ($select['br_select_gateway'] == "true"){
        $results = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "cdi");
        if (count($results) > 0) {
          foreach ($results as $row) {
            if ($row->cdi_status == 'open' and wc_get_order($row->cdi_order_id) !== false and $row->cdi_tracking) {
              $selected[] = preg_replace("/[^A-Z0-9]/", "", $row->cdi_tracking);
            }
          }
        }
      }
      if ($select['br_select_orders'] == "true" and $select['cdi_br_select_fromdate'] !== "" and $select['cdi_br_select_todate'] !== ""){
        $datetime1 = new DateTime(str_replace('-', '', $select['cdi_br_select_fromdate']));
        $datetime2 = new DateTime(str_replace('-', '', $select['cdi_br_select_todate']));
        $difference = $datetime1->diff($datetime2);
        //
        // **** Limit of search = 30 days and a max of 200 orders
        //
        if ( ($difference->invert == 0) && ($difference->days < 30)) {
          $customer_orders = get_posts( array(
            'numberposts' => 200,
            'orderby'     => 'date',
            'order'       => 'DESC',
            'post_type'   => wc_get_order_types(),
            'post_status' => array_keys( wc_get_order_statuses() ),
            'date_query' => array(
              'after' => date('Y-m-d', strtotime($select['cdi_br_select_fromdate'] . ' -1 day')),
              'before' => date('Y-m-d', strtotime($select['cdi_br_select_todate'] . ' +1 day')) 
                )
            ) );
          foreach ( $customer_orders as $customer_order ) {
            $order = wc_get_order( $customer_order );
            $orderid = $order->get_id();
            $cdi_tracking = get_post_meta($orderid, '_cdi_meta_tracking', true);
            if ($cdi_tracking) {
              $selected[] = preg_replace("/[^A-Z0-9]/", "", $cdi_tracking);
            }
          }
        }
      }
      if ($select['br_select_numorders'] == "true" and $select['br_select_numorders_param1'] !== ""){
        $arraylistenumorders = explode(",", $select['br_select_numorders_param1']) ;
        foreach($arraylistenumorders as $orderid){
          $orderid = preg_replace("/[^0-9]/", "", $orderid);
          $cdi_tracking = get_post_meta($orderid, '_cdi_meta_tracking', true);
          if ($cdi_tracking) {
            $selected[] = preg_replace("/[^A-Z0-9]/", "", $cdi_tracking);
          }
        }
      }
      if ($select['br_select_codesuivi'] == "true" and $select['br_select_codesuivi_param1'] !== ""){
        $arraylistecodesuivi = explode(",", $select['br_select_codesuivi_param1']) ;
        foreach($arraylistecodesuivi as $codesuivi){
          $codesuivi = preg_replace("/[^A-Z0-9]/", "", $codesuivi);
          if ($codesuivi) {
            $selected[] = $codesuivi ;
          }
        }
      }
      if ($select['br_select_extern'] == "true" and $select['br_select_extern_param1'] !== ""){
        $arraylisteextern = explode(",", $select['br_select_extern_param1']) ;
        foreach($arraylisteextern as $extern){
          $extern = preg_replace("/[^A-Z0-9]/", "", $extern);
          if ($extern) {
            $selected[] = $extern ;
          }
        }
      }
      if ($select['br_select_annulcode'] == "true" and $select['br_select_annulcode_param1'] !== ""){
        $arraylisteannulcode = explode(",", $select['br_select_annulcode_param1']) ;
        foreach($arraylisteannulcode as $annulcode){
          $annulcode = preg_replace("/[^A-Z0-9]/", "", $annulcode);
          if ($annulcode) {
            $selected = array_diff($selected, array($annulcode));
          }
        }
      }
      $selected = array_unique ($selected) ;
      sort ($selected) ;
      update_option('cdi_selected_bremise', $selected) ;
      $selecteddisplay = self::cdi_get_br_displayselected($selected) ;
      echo json_encode(array("message" => count($selected) . " codes de colis sélectionnés, qui sont en attente pour la confection de votre bordereau.", "htmlselected" => $selecteddisplay)) ;
      wp_die();
    }
    public static function cdi_ajax_bremise_clear_select() {
      delete_option('cdi_selected_bremise') ;
      echo json_encode(array("message" => "La liste des colis sélectionnés a été purgée. Vous pouvez maintenant refaire vos sélections.", "htmlselected" => "")) ;
      wp_die();
    }
    public static function cdi_ajax_bremise_exec_bordereau() {
      global $base64bordereau;
      require_once dirname(__FILE__) . '/ColissimoAF/ColissimoAFAutoload.php';
      $errorws = "" ;
      $selected = self::cdi_get_br_selected() ;
      if (!empty($selected)) {
        $wsdl = array();
        $wsdl[ColissimoAFWsdlClass::WSDL_URL] = 'http://ws.Colissimo.fr/sls-ws/SlsServiceWS?wsdl';
        $wsdl[ColissimoAFWsdlClass::WSDL_CACHE_WSDL] = WSDL_CACHE_NONE;
        $wsdl[ColissimoAFWsdlClass::WSDL_TRACE] = true;
        $wsdlObject = new ColissimoAFStructGenerateBordereauByParcelsNumbers($wsdl);
        $wsdlObject->setContractNumber(get_option('wc_settings_tab_colissimo_ws_ContractNumber')); 
        $wsdlObject->setPassword(get_option('wc_settings_tab_colissimo_ws_Password'));
        $wsdlObject->generateBordereauParcelNumberList = new ColissimoAFStructGenerateBordereauParcelNumberList();
        foreach ($selected as $parcelsnumbers) {
          $wsdlObject->generateBordereauParcelNumberList->parcelsNumbers[] = $parcelsnumbers ;
        }
        $ColissimoAFServiceGenerate = new ColissimoAFServiceGenerate();
        if ($ColissimoAFServiceGenerate->generateBordereauByParcelsNumbers($wsdlObject)) {
          $ok = $ColissimoAFServiceGenerate->getResult();
          $retid = $ok->return->messages[0]->id;
          $retmessageContent = $ok->return->messages[0]->messageContent;
          if ($retid == 0) {
            // process the data
            $address = $ok->return->bordereau->bordereauHeader->address ;
            $bordereauNumber = $ok->return->bordereau->bordereauHeader->bordereauNumber ;
            $clientNumber = $ok->return->bordereau->bordereauHeader->clientNumber ;
            $codeSitePCH = $ok->return->bordereau->bordereauHeader->codeSitePCH ;
            $company = $ok->return->bordereau->bordereauHeader->company ;
            $numberOfParcels = $ok->return->bordereau->bordereauHeader->numberOfParcels ;
            $publishingDate = $ok->return->bordereau->bordereauHeader->publishingDate ;
            if ($base64bordereau) {
              WC_function_Colissimo::cdi_uploads_put_contents ($bordereauNumber, 'bordereau', $base64bordereau) ;
              $listebordereaux = get_option('cdi_liste_borderaux_remise');
              if (empty($listebordereaux)) {
                $listebordereaux = array() ;
              }
              $listebordereaux[] = array('address' => $address, 
                                         'bordereauNumber' => $bordereauNumber,
                                         'clientNumber' => $clientNumber,
                                         'codeSitePCH' => $codeSitePCH,
                                         'company' => $company,
                                         'numberOfParcels' => $numberOfParcels,
                                         'publishingDate' => $publishingDate) ;
              // Sort and Suppress old Bordereaux
              function cmpbr($a, $b) { return strcmp($b['publishingDate'], $a['publishingDate']); }
              usort($listebordereaux, "cmpbr");
              $newlistbordreaux = array() ;
              $nbbordereaux = 0 ;
              foreach ($listebordereaux as $bordereau) {
                $nbbordereaux = $nbbordereaux + 1 ;
                if ($nbbordereaux <= 200) { // Max in array option and pdf files - May be changed
                  $newlistbordreaux[] = $bordereau ;      
                }else{
                  // Suppress old pdf
                  $upload_dir = wp_upload_dir();
                  $dircdistore = trailingslashit($upload_dir['basedir']).'cdistore';
                  $url = wp_nonce_url('plugins.php?page=colissimo-delivery-integration');
                  $creds = request_filesystem_credentials($url, "", false, false, null) ;
                  global $wp_filesystem;
                  $filename = trailingslashit($dircdistore). 'CDI-' . 'bordereau' . '-' . $bordereau['bordereauNumber'] .'.txt';
                  $result = $wp_filesystem->delete( $filename) ;
                }
              }
              update_option('cdi_liste_borderaux_remise',$newlistbordreaux);
            }else{
              $errorws = __(' ===> Error processing Bordereau de remise Colissimo', 'colissimo-delivery-integration')  . ' - ' . $retid . ' : ' . $retmessageContent ;
            }
          }else{
            // process the error from soap server
            WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $retid, 'exp');
            WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $retmessageContent, 'exp');
            $last = $ColissimoAFServiceGenerate->getLastRequest();
            WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $last, 'exp');
            $ret = $ColissimoAFServiceGenerate->getLastResponse();
            WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $ret, 'exp');
            $errorws = __(' ===> Error processing Bordereau de remise Colissimo', 'colissimo-delivery-integration')  . ' - ' . $retid . ' : ' . $retmessageContent ;
          }
        }else{
          // process the error from soap client
          $nok = $ColissimoAFServiceGenerate->getLastError();
          $last = $ColissimoAFServiceGenerate->getLastRequest();
          $ret = $ColissimoAFServiceGenerate->getLastResponse();
          $retid = $nok['ColissimoAFServiceGenerate::generateBordereauByParcelsNumbers']->faultcode;
          $retmessageContent = $nok['ColissimoAFServiceGenerate::generateBordereauByParcelsNumbers']->faultstring;
          WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $retid, 'tec');
          WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $retmessageContent, 'tec');
          WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $last, 'tec');
          WC_function_Colissimo::cdi_debug(__LINE__ ,__FILE__ , $ret, 'tec');
          $errorws = __(' ===> Error processing Bordereau de remise Colissimo', 'colissimo-delivery-integration') . ' - ' . $retid . ' : ' . $retmessageContent ;
        }
      }
      if ($errorws !== "") {
        $message = $errorws ;
      }else{
        $message = "Votre bordereau a été généré. C'est le premier de votre liste. Cliquez sur \"Voir\" pour le visualiser ou l'imprimer" ;
      }
      $selecteddisplay = "" ;
      $bordereauxdisplay = self::cdi_body_table_bordereau() ;
      echo json_encode(array("message" => $message, "htmlselected" => $selecteddisplay, "htmlbordereaux" => $bordereauxdisplay)) ;
      wp_die();
    }

    public static function cdi_body_table_bordereau() {
      $listebordereaux = get_option('cdi_liste_borderaux_remise');
      $htmlbody = "" ;
      if (empty($listebordereaux)) {
        $htmlbody .= "<tr class='no-items'><td colspan='3' class='colspanchange'>Aucun bordereaux de remise n'a été généré.</td></tr>";
      }else{
        foreach ($listebordereaux as $bordereau) {
          $tdtitrebordereau = '' ;
          foreach ($bordereau as $key=>$value) {
            $tdtitrebordereau .= ' | ' . $key . '=>' . $value ;
          }
          $datebordereau = str_replace("T", " ",$bordereau['publishingDate']) ;
          $tdvoirbordereau = '<td style="overflow:hidden; white-space:nowrap; text-overflow: ellipsis;"><form method="post" id="cdi_bordereau_voir" action="" style="display:inline-block;"><input type="hidden" name="cdi_bordereau_voir_post" value="' . $bordereau['bordereauNumber'] . '"><input type="submit" name="cdi_bordereau_voir" value="Voir"  title="Print bordereau' . $tdtitrebordereau . '" /></form></td>' ;
          $htmlbody .= '<tr><td>' . $datebordereau . '</td><td>' . $bordereau['bordereauNumber'] . '</td><td>' . $bordereau['numberOfParcels'] . '</td>' . $tdvoirbordereau . '</tr>';
        }
      }
      return $htmlbody ;
    }

    public static function cdi_bordereau_voir() {
      if ( isset($_POST['cdi_bordereau_voir']) ) {
        global $woocommerce;
        global $wpdb;
        $bordereau_id = $_POST['cdi_bordereau_voir_post'] ;
        if (current_user_can('cdi_gateway')) {
          $cdi_locbordereau = WC_function_Colissimo::cdi_uploads_get_contents ($bordereau_id, 'bordereau'); 
          if ($cdi_locbordereau) {
            $cdi_locbordereau_pdf = base64_decode ($cdi_locbordereau);
            $out = fopen('php://output', 'w');
            $thepdffile = 'Bordereau-' . $bordereau_id . '-' . date('YmdHis') . '.pdf' ;
            header('Content-Type: application/pdf' );
            header('Content-Disposition: attachment; filename=' . $thepdffile );
            fwrite($out, $cdi_locbordereau_pdf) ;
            fclose($out);
            die ();
          }

        } // End current_user_can
      }
    } 
}


?>
