<?php

/**
 * This file is part of the Colissimo Delivery Integration plugin.
 * (c) Harasse
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/****************************************************************************************/
/* Cdi Référence aux livraisons - js for Open Map                                                */
/****************************************************************************************/
     
       $jsmap = ' <div id="' . $parammap['id'] . '" style="width:' . $parammap['w'] . ';height:' . $parammap['h'] . ';' . $parammap['style'] . ' "><div id="mapom" style="height:100%; width:100%; position:absolute; top:0px; left:0px;"></div><div id="popup"></div></div><br/>' ;
       $jsmap .=   "<script>  var sites = " . $listsites . " ;" ; 
       $jsmap .=  '
var listFeatures = [];
for (var i = 0; i < sites.length; i++) {
  var site = sites[i]; 
  var iconFeature = new ol.Feature({
    geometry: new ol.geom.Point(ol.proj.fromLonLat([site[1], site[0]]),),
    name: "<div style=\'display:inline-block; height:200px; overflow:scroll;\'>"+site[2]+"</div><button id=\'close\' style=\'float:right\' onclick=\'suppopover(); return false;\'>X</button>", 
  });
  if(site[3]!=null) { 
    iconFeature.setStyle(new ol.style.Style({
      image: new ol.style.Icon({
        anchor: [0.5, 46],
        anchorXUnits: "fraction",
        anchorYUnits: "pixels",
        src: site[3],
      })
    }));
    listFeatures.push(iconFeature) ;
  }
} 
const iconLayerSource = new ol.source.Vector({
  features: listFeatures,
});
const iconLayer = new ol.layer.Vector({
  source: iconLayerSource,
});
var map = new ol.Map({
  target: "mapom",
  layers: [
    new ol.layer.Tile({
      source: new ol.source.OSM()
    }),
    iconLayer,
  ],
  view: new ol.View({
    center: ol.proj.fromLonLat([' . $parammap['lon'] . ', ' . $parammap['lat'] . ']),
    zoom: ' . $parammap['z'] . '
  })
});
jQuery(document).ready(function ($) {
  map.on("click", function(evt) {
    map.removeOverlay(popup);
    suppopover();
    var element = document.getElementById("popup");
    var popup = new ol.Overlay({
      element: element,
      positioning: "bottom-center",
      stopEvent: false,
      offset: [0, -50]
    });
    map.addOverlay(popup);
    var feature = map.forEachFeatureAtPixel(evt.pixel,
      function(feature) {
        return feature;
      });
    if (feature) {
      var coordinates = feature.getGeometry().getCoordinates();
      popup.setPosition(coordinates);
      $(element).popover({
        placement: "top",
        html: true,
        content: feature.get("name"),
        container: "body"
        });
      $(element).popover("show");
    }else{
      $(element).popover("destroy");
    }
    map.on("pointermove", function(e) {
      if (e.dragging) {
        return;
      }
      //$(element).popover("destroy");
    });
  });
});
</script>' ;

?>

