<?php
if (isset($noty) && $noty == 1) { ?>
    <div class="updated">
        <p><?php _e("Les options du plugin Mondial Relay pour WooCommerce ont bien été mises à jour.", 'woocommerce-mondialrelay') ?></p>
    </div>
<?php } ?>

<h1><?php _e("Compte Mondial Relay", 'woocommerce-mondialrelay') ?></h1>

<h3><?php _e("Configuration du compte Mondial Relay", 'woocommerce-mondialrelay') ?></h3>

<form method="post" action="" id="mondialrelay_admin_compte">

    <table class="form-table">
        <tbody>
        <?php foreach ($labels_compte as $key => $label) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="<?php echo $key ?>"><?php echo $label['label'] ?> </label>
                    <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span>
                </th>
                <td>
                    <input name="<?php echo $key ?>" type="text" id="<?php echo $key ?>" value="<?php echo $champs[$key]; ?>" class="regular-text">
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

   <br>

    <h3><?php _e("Configuration de la livraison Mondial Relay", 'woocommerce-mondialrelay') ?></h3>

    <form method="post" action="">

        <table class="form-table">
            <tbody>
            <?php foreach ($labels_livraison as $key => $label) { ?>
                <tr valign="top">
                    <th scope="row"><label for="<?php echo $key ?>"><?php echo $label['label'] ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
                    <td>
                        <select name="<?php echo $key ?>">
                            <option value="" disabled> Choisir
                                <?php
                                foreach($label['options'] as $cle => $option) { ?>
                            <option value="<?php echo $option ?>" <?php if ($champs[$key] == $option) echo 'selected'; ?>> <?php echo $cle ?>
                                <?php }
                                ?>
                        </select>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>

        <p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php _e("Enregistrer les changements", 'woocommerce-mondialrelay') ?>"></p>

    </form>

    <div id="message" class="woocommerce-mondialrelay-message">
        <div class="squeezer">
            <p><strong><?php _e("Aide", 'woocommerce-mondialrelay') ?></strong><br>
                <?php _e("Pour pouvoir créer des expéditions via Mondial Relay, l'inscription au service Mondial Relay est obligatoire afin d'obtenir votre code client + clé privée.", 'woocommerce-mondialrelay') ?><br>
                <?php _e("Si vous n’avez pas encore souscrit de compte professionnel Mondial Relay, vous pouvez en faire la demande à la société Mondial Relay via leur ", 'woocommerce-mondialrelay') ?> <a href="<?php echo WC_MondialRelay::MONDIALRELAY_INSCRIPTION ?>" target="_blank"><?php _e("formulaire de contact", 'woocommerce-mondialrelay') ?></a>.<br>
                <?php _e("Pour plus d'informations sur les options du plugin, consultez", 'woocommerce-mondialrelay') ?> <a target="_blank" href="<?php echo WC_MondialRelay::DOCUMENTATION; ?>/compte-mondial-relay"> <?php _e("la documentation", 'woocommerce-mondialrelay') ?></a>.</p>
        </div>
    </div>