<?php
if (isset($id_livraison_error) && $id_livraison_error == 1) { ?>
    <div class="error">
        <p><?php _e("<strong>Erreur :</strong> les identifiants de livraison Mondial Relay doivent seulement contenir des caractères alpha-numériques ainsi que les caractères \"_\" et \"-\" ", 'woocommerce-mondialrelay') ?></p>
    </div>
<?php } ?>

<h1><?php _e("Point relais", 'woocommerce-mondialrelay') ?></h1>

<?php
if (isset($noty) && $noty == 1) { ?>
    <div class="updated">
        <p><?php _e("Les options du plugin Mondial Relay pour WooCommerce ont bien été mises à jour.", 'woocommerce-mondialrelay') ?></p>
    </div>
<?php } ?>

<form method="post" action="" id="mondialrelay_admin_recherche">

    <h3><?php _e("Configuration de la recherche de points Mondial Relay", 'woocommerce-mondialrelay') ?></h3>
    <table class="form-table">
        <tbody>
        <?php foreach ($labels_points as $key => $label) { ?>
            <tr valign="top">
                <th scope="row"><label for="<?php echo $key ?>"><?php echo $label['label'] ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
                <td>
                    <?php if ($label['type'] == 'text') { ?>
                        <input name="<?php echo $key ?>" type="text" id="<?php echo $key ?>" value="<?php echo $champs[$key]; ?>" class="regular-text">
                    <?php } elseif ($label['type'] == 'radio') { ?>
                        <input type="radio" name="<?php echo $key ?>" id="<?php echo $key . '_oui' ?>" value="true" <?php if ($champs[$key] == 'true') echo 'checked'; ?>><label for="<?php echo $key . '_oui' ?>"><?php _e("Oui", 'woocommerce-mondialrelay') ?></label>
                        <input type="radio" name="<?php echo $key ?>" id="<?php echo $key . '_non' ?>" value="false" <?php if ($champs[$key] == 'false') echo 'checked'; ?>><label for="<?php echo $key . '_non' ?>"><?php _e("Non", 'woocommerce-mondialrelay') ?></label>
                    <?php } elseif ($label['type'] == 'select') { ?>
                        <select name="<?php echo $key ?>">
                            <option value="" disabled> <?php _e("Choisir", 'woocommerce-mondialrelay') ?>
                                <?php
                                foreach($label['options'] as $cle => $option) { ?>
                            <option value="<?php echo $option ?>" <?php if ($champs[$key] == $option) echo 'selected'; ?>> <?php echo $cle ?>
                                <?php }
                                ?>
                        </select>
                    <?php } elseif ($label['type'] == 'multiple') { ?>
                        <br>
                    <?php
                    foreach($label['options'] as $cle => $option) { ?>
                        <label><input type="checkbox" name="<?php echo $key ?>[]" value="<?php echo $option ?>" <?php if (WC_MondialRelay_Helpers::is_pays_autorise($old_pays_autorises, $option)) echo 'checked'; ?>> <?php echo $cle ?></label><br>
                    <?php } ?>
                    <?php } ?>
                </td>
            </tr>
        <?php } ?>
        <?php foreach ($labels_livraison as $key => $label) { ?>
            <tr valign="top">
                <th scope="row"><label for="<?php echo $key ?>"><?php echo $label['label'] ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
                <td>
                    <select name="<?php echo $key ?>">
                        <option value="" disabled> <?php _e("Choisir", 'woocommerce-mondialrelay') ?>
                            <?php
                            foreach($label['options'] as $cle => $option) { ?>
                        <option value="<?php echo $option ?>" <?php if ($champs[$key] == $option) echo 'selected'; ?>> <?php echo $cle ?>
                            <?php }
                            ?>
                    </select>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php _e("Enregistrer les changements", 'woocommerce-mondialrelay') ?>"></p>

</form>

<div id="message" class="woocommerce-mondialrelay-message">
    <div class="squeezer">
        <p><strong><?php _e("Aide", 'woocommerce-mondialrelay') ?></strong><br>
            <?php _e("Pour plus d'informations sur les options du plugin, consultez", 'woocommerce-mondialrelay') ?> <a target="_blank" href="<?php echo WC_MondialRelay::DOCUMENTATION; ?>/points-relais"> <?php _e("la documentation", 'woocommerce-mondialrelay') ?></a>.</p>
    </div>
</div>